#include "BOLTApp.h"
#include "db/BOLTdb.h"
#include "db/BOLTdbConfig.h"

#include "ctrl/BOLTChooser.h"
#include "ctrl/BOLTUser.h"
//#include "ctrl/BOLTReport.h"
#include "BOLTFrm.h"
#include "form/BOLTforms.h"

#include "ctrl/BOLTBackup.h"

#include "ctrl/BOLTQuickPicks.h"
#include "form/bfSettings.h"


enum {
	ID_BS_CODES=13243,
		ID_BS_RULES,
		ID_BS_USERS,
		ID_BS_RATES,
		ID_BS_CHARGETYPES,
		ID_BS_BACKUP,
		ID_BS_BACKUPREPORTS,
		ID_BS_RESTORE,
		ID_BS_QUICKPICK
};

//IMPLEMENT_DYNAMIC_CLASS(bfSettings,BOLTPage)
BEGIN_EVENT_TABLE(bfSettings,BOLTPage)
EVT_BUTTON(ID_BS_USERS,bfSettings::OnButton)
EVT_BUTTON(ID_BS_BACKUPREPORTS,bfSettings::OnButton)
EVT_BUTTON(ID_BS_BACKUP,bfSettings::OnButton)
EVT_BUTTON(ID_BS_RESTORE,bfSettings::OnButton)
EVT_BUTTON(ID_BS_QUICKPICK,bfSettings::OnButton)
END_EVENT_TABLE()

bfSettings::bfSettings(wxNotebook *parent,BOLTdb *db,RECORD_ID recID):
	BOLTPage(parent,-1,wxDefaultPosition,wxDefaultSize,wxTAB_TRAVERSAL|wxWANTS_CHARS,TEXT_TOOLS)
{
		this->db=db;

		wxGridSizer *topSizer;
		wxBoxSizer *winSizer;
		wxStaticBoxSizer *tmpSizer;
		winSizer=new wxBoxSizer(wxVERTICAL);
		topSizer=new wxGridSizer(1,3,0);
//			SetBackgroundColour(COLOR_HOME);

#define BS_ADD(text,id,bitmap) \
		tmpSizer=new wxStaticBoxSizer(new wxStaticBox(this,-1,text),wxVERTICAL ); \
		tmpSizer->Add(new wxBitmapButton(this,id,bitmap),0,wxALL,5); \
		topSizer->Add(tmpSizer,0,wxALIGN_CENTER|wxALL,10);

		BS_ADD("Quick Picks",ID_BS_QUICKPICK,wxBitmap("BUTTONQUICKPICKS"))
		BS_ADD("Backup",ID_BS_BACKUP,wxBitmap("BUTTONBACKUP"))
		BS_ADD("Restore",ID_BS_RESTORE,wxBitmap("BUTTONRESTORE"))

		winSizer->Add(topSizer,1,wxALIGN_CENTER|wxALL,5);
//		SetAutoLayout(TRUE);
		SetSizerAndFit(winSizer);
	    FitInside();
}  

void bfSettings::OnButton(wxCommandEvent &event)
{
BOLTBackup *backup;
//BOLTConstraints *bc;
BOLTUserManager *bUM;
//BOLTChargeTypesManager *bCT;
//BOLTRates *bR;
BOLTQuickPicks *bQP;

	switch(event.GetId())
	{
	case ID_BS_USERS:
		bUM=new BOLTUserManager(this,db);
		bUM->Destroy();
		break;
	case ID_BS_BACKUP:
			backup=new BOLTBackup(db,this);
			backup->DoBackup();
			backup->Destroy();
		break;
	case ID_BS_BACKUPREPORTS:
			backup=new BOLTBackup(db,this);
			backup->DoBackupReports();
			backup->Destroy();
		break;
	case ID_BS_RESTORE:
			backup=new BOLTBackup(db,this);
			backup->DoRestore();
			backup->Destroy();
		break;
	case ID_BS_QUICKPICK:
		bQP=new BOLTQuickPicks(this,db);
		bQP->Destroy();
		break;
	}
}

void bfSettings::DoEditCodes()
{
//	BOLTCodes *bCodes;
	QRY_ID qry;
	void *row;

	wxArrayString slDescriptions;
	wxArrayString slClasses;
	wxArrayString slSuperclasses;

	wxString tStr;

	tStr.Printf("select c.class,c.superclass, \
		CONCAT(c.class,if(sc.full is not null,concat(':',sc.full),''),' [',count(c.id),' entries]')\
		from codes c left join codes sc \
		on c.superclass=sc.short and c.class=sc.class \
		group by c.class,c.superclass order by c.class,c.superclass");

	qry=db->Query((char *)tStr.c_str(),tStr.Length());
	if (qry==NULL)
	{
		if (db->IsError()) { LOG_ERROR(db->GetError()); }
		return; 
	}
	int i=0;
	while (row=db->FetchRow(qry))
	{
		tStr=db->FetchQueryResult(qry,row,0); slClasses.Add(tStr);
		tStr=db->FetchQueryResult(qry,row,1); slSuperclasses.Add(tStr);
		tStr=db->FetchQueryResult(qry,row,2); slDescriptions.Add(tStr);
		i++;
	}
	db->FreeQuery(qry);
	i=wxGetSingleChoiceIndex("Which code catagory would you like to modify ?","Edit Codes",slDescriptions,this);
	if (i>=0)
	{
//		bCodes=new BOLTCodes(this,-1,db,"codes",slClasses[i].c_str(),slSuperclasses[i].c_str());
//		bCodes->EditCodes();
	}
}
